/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.interfaces.SurvivesOnBoneBlocks;

public class BlockBoneMushroom
extends BlockBaseNotFull
implements SurvivesOnBoneBlocks,
BehaviourPlant {
    private static final VoxelShape SHAPE_NORTH = BlockBoneMushroom.m_49796_((double)1.0, (double)1.0, (double)8.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = BlockBoneMushroom.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)8.0);
    private static final VoxelShape SHAPE_WEST = BlockBoneMushroom.m_49796_((double)8.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_EAST = BlockBoneMushroom.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)8.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_UP = BlockBoneMushroom.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty AGE = BlockProperties.AGE_THREE;

    public BlockBoneMushroom() {
        super(Materials.NETHER_PLANT.m_284180_(MapColor.f_283916_).m_60977_());
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.setDropItself(false);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{FACING, AGE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_UP;
    }

    @Environment(value=EnvType.CLIENT)
    public float m_7749_(BlockState state, BlockGetter view, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (direction == Direction.DOWN) {
            return false;
        }
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = world.m_8055_(blockPos);
        return this.isSurvivable(blockState);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (this.m_7898_(state, (LevelReader)world, pos)) {
            return state;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(state, world, pos, random);
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < 2 && random.m_188503_(32) == 0) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = this.m_49966_();
        Level worldView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        Direction[] directions = ctx.m_6232_();
        for (int i = 0; i < directions.length; ++i) {
            Direction direction2;
            Direction direction = directions[i];
            if (direction == Direction.UP || !(blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)(direction2 = direction.m_122424_()))).m_60710_((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }
}

